//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Outlaws
//  Copyright (C) 2016 RETROBYTES PRODUCTIONS
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <cpctelera.h>
#include "../defines.h"
#include "../sprites/sprites.h"
#include "../sprites/tilemaps.h"

#ifndef _VIDEO_H_
#define _VIDEO_H_

extern u8* const g_scrbuffers[2];
extern u8 level;

cpctm_declareMaskTable(g_transparencyMaskTable);

void drawClippedSprite(u8* sprite, i8 xPos, u8 yPos, u8 width, u8 height);
void drawClippedSpriteOnBuffer(u8* sprite, i8 xPos, u8 yPos, u8 width, u8 height, u8* buffer);
void eraseClippedSprite(i8 xPos, u8 yPos, u8 width, u8 height);
void setUpVideo();
void swapBuffers(u8** scrbuffers);
void forceFrontBuffer(u8** scrbuffers);

#endif
